<?php
/*#################################################################################
	AdLogger
	- An open-source tracking tool for preventing click fraud

	Copyright 2006 by Trevor Fitzgerald
	http://www.adlogger.org

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

	If you find this script useful, please share it with others!

	Thank you!
*/#################################################################################

// Include the configuration files.
require ("../config_database.php");
require ("../config_settings.php");
require ("../config_admin.php");

// Make sure that the person is logged in.
require ("./loginverify.php");

/*
 * Include the functions. Start the page timer, output the opening HTML,
 * and verify that we can actually connect to the database.
*/
require ("./functions.php");
	$start_time = micro_time(0);
	bodyHeader('all_clicks', $version_num);
	bodyNavigation('all_clicks');
	check_db_connection($adlogger_db_connect, $adlogger_db_select);

// Grab the user's preferences from the URL, if they're set.
if (isset($_GET['sortnum']) && !empty($_GET['sortnum'])) {
	$sortnum = $_GET['sortnum'];
	$sortname = $_GET['sortname'];
	$sortorder = $_GET['sortorder'];
} else {
	$sortnum = 10;
	$sortname = 'id';
	$sortorder = 'DESC';
}

// For pagination, we need to know what page we're trying to access
if (isset($_GET['pageno']) && !empty($_GET['pageno'])) {
   $pageno = $_GET['pageno'];
} else {
   $pageno = 1;
}
?>

<div id="side-bar">
	<div>
		<p class="sideBarTitle">Click Information</p>
	</div>
</div>

<div id="main-copy">

	<h1 id="introduction1">View Preferences</h1>

	<p>Choose your sorting preferences:</p>
	<form name="sortdata" action="<?php echo $_SERVER['PHP_SELF']; ?>" method="get">
		<fieldset>

			<legend>All Clicks</legend>

			<div align="center">
				View 
					<select name="sortnum">
						<option value="10"<?php select_item_if_chosen('10', $sortnum); ?>>10</option>
						<option value="25"<?php select_item_if_chosen('25', $sortnum); ?>>25</option>
						<option value="50"<?php select_item_if_chosen('50', $sortnum); ?>>50</option>
					</select>
				clicks at a time sorted by 
					<select name="sortname">
						<option value="id"<?php select_item_if_chosen('id', $sortname); ?>>Date/Time</option>
						<option value="disp_url"<?php select_item_if_chosen('disp_url', $sortname); ?>>Display Page URL</option>
					</select>
				in 
					<select name="sortorder">
						<option value="DESC"<?php select_item_if_chosen('DESC', $sortorder); ?>>Descending</option>
						<option value="ASC"<?php select_item_if_chosen('ASC', $sortorder); ?>>Ascending</option>
					</select>
				order. 
					<input type="submit" value="Sort" />
			</div>

		</fieldset>
	</form>

	<h1 id="click_history">Click History</h1>
	<br />
	<div align="center">
<?php
/*
 * Begin pagination code
 */
 	// Count how many rows total so we know how many pages to spread it out over.
	$result = mysql_query("SELECT COUNT(id) FROM " . $db_table_prefix . "logfiles");
		$row = mysql_fetch_array($result);
		$numrows = $row['COUNT(id)'];

	if (isset($_GET['sortnum']) && !empty($_GET['sortnum'])) {
		$rows_per_page = $_GET['sortnum'];
	} else {
		$rows_per_page = 10;
	}
	$lastpage = ceil($numrows/$rows_per_page);
	if ($lastpage == 0) $lastpage = 1;

	$pageno = (int)$pageno;

	$limit = 'LIMIT ' .($pageno - 1) * $rows_per_page .',' .$rows_per_page;

	if ($pageno <= 1) {
		echo " FIRST PREV ";
	} else {
		echo " <a href='{$_SERVER['PHP_SELF']}?pageno=1&amp;sortnum=$rows_per_page&amp;sortname=$sortname&amp;sortorder=$sortorder#click_history'>FIRST</a> ";
		$prevpage = $pageno - 1;
		echo " <a href='{$_SERVER['PHP_SELF']}?pageno=$prevpage&amp;sortnum=$rows_per_page&amp;sortname=$sortname&amp;sortorder=$sortorder#click_history'>PREV</a> ";
	}

	echo " ( Page $pageno of $lastpage ) ";

	if ($pageno >= $lastpage) {
		echo " NEXT LAST ";
	} else {
		$nextpage = $pageno + 1;
		echo " <a href='{$_SERVER['PHP_SELF']}?pageno=$nextpage&amp;sortnum=$rows_per_page&amp;sortname=$sortname&amp;sortorder=$sortorder#click_history'>NEXT</a> ";
		echo " <a href='{$_SERVER['PHP_SELF']}?pageno=$lastpage&amp;sortnum=$rows_per_page&amp;sortname=$sortname&amp;sortorder=$sortorder#click_history'>LAST</a> ";
	}
###################################################
?>
	</div>
	<br />

	<?php if ($numrows > 0) { ?>

			<table summary="all_clicks" width="100%" id="greytable">

				<thead id="greythead">
					<tr>
						<th scope="col">Click ID</th>
						<th scope="col">Date</th>
						<th scope="col">Time</th>
						<th scope="col">IP Address</th>
						<th scope="col">Display Page URL</th>
					</tr>
				</thead>

				<tbody id="greytbody">

				<?php
					/*
					 * Perform the query on the database to grab the rows.
					*/
					$sql = "SELECT *
								FROM " . $db_table_prefix . "logfiles
									ORDER BY $sortname $sortorder
										$limit
											";
					$result = mysql_query($sql) or die(mysql_error());

					/*
					 * Start the loop to display them.  In this loop, the script creates
					 * a new table row for each entry it finds from the database.
					*/
					while($row = mysql_fetch_array($result)) {
						$id = $row['id'];
						$timestamp = $row['timestamp'];
							// Convert that UNIX timestamp to something a little more useable
							$date = date('M j, Y', $timestamp);
							$time = date('g:i:s a', $timestamp);
						$visitor_ip = $row['visitor_ip'];
						$disp_url = urldecode($row['disp_url']);
					?>
						<tr class="odd">
							<th scope="row"><a href="./click_info.php?id=<?php echo $id; ?>"><?php echo number_format($id); ?></a></th>
							<td><?php echo $date; ?></td>
							<td><?php echo $time; ?></td>
							<td><?php echo $visitor_ip; ?></td>
							<td><?php echo shortenURL($disp_url); ?></td>
						</tr>
					<?php } /* End the loop. */ ?>

				</tbody>

			</table>
	<?php } ?>
</div>

<?php
// Output the closing HTML for the footer.
bodyFooter('all_clicks', $start_time);
?>